;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; memory section - multiplexer 
;; added by roma on 10 June '05
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; bv2 is the address bit vector
; so depending on bv2 pull out the corresponding entry in bv1
; lets assume hat bv2 is a bit vector and a valid simple formula

; bv1 - bit vector is memory
; bv2 - bit vector is address location os required word
; c1 - is the word size
; c2 - number of bits reqd.

(defun mem-multiplexer (bv1 bv2)
  (if (equal bv2 'nil)
      bv1
    (progn
      (let* ((rev-bv2 (reverse bv2))
	     (len-bv1 (length bv1)))
	(if (equal (car rev-bv2) 0)
	    (mem-multiplexer (subseq bv1 0 (/ len-bv1 2)) (reverse (cdr rev-bv2)))
	  (mem-multiplexer (subseq bv1 (/ len-bv1 2)) (reverse (cdr rev-bv2))))))))


(defun arefw (c1 bv1 bv2 c2)
  (let ((reqd-add (* c1 bv2))
	(reqd-word (mem-multiplexer bv1 reqd-add)))
    (if (= (length args) 4)
	(subseq reqd-word (- (length reqd-word) c2))
      reqd-word)))
  

(defun arefb (bv1 bv2 c1)
  (arefw 1 bv1 bv2 c1))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; memory section - type checking for formulas
;; of the type (bv1 bv2).
;; added by roma on 16 June '05
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; so if the formula has length 2, then both bv1 and
;; bv2 should be simple-formulas and the condition for 
;; type is: (log2(type bv1)) >= (log2(type bv2)).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun mem-type-check (form e d)
  (let ((cform form))
    (and (= (length cform) 2)
	 (let ((type-bv1 (simple-formulap (car cform) e d))
	       (type-bv2 (simple-formulap (cdr cform) e d)))
	   (and (and type-bv1 type-bv2)
		(>= (log bv1 2) (log bv2 2)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; memory section - type checking for formulas
;; of the type (bv1 bv2).
;; added by roma on 16 June '05
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; so if the formula has length 2, then both bv1 and
;; bv2 should be simple-formulas and the condition for 
;; type is: (log2(type bv1)) >= (log2(type bv2)).
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun mem-multiplexer (bv1 bv2)
  (if (equal bv2 'nil)
      bv1
    (progn
      (if (equal (car bv2) 0)
	  (mem-multiplexer (subseq bv1 0 (/ (length bv1) 2)) (cdr bv2))
	(mem-multiplexer (subseq bv1 (/ (length bv1) 2)) (cdr bv2))))))

(defun arefw-type (args)
  (let* ((e1 (elt args 0))
	 (e2 (elt args 1)))
    (progn
      (let ((reqd-slice (mem-multiplexer e1 e2)))
	(make-formula      :fn 'arefw
			   :type (length reqd-slice)
			   :slot1 t
			   :args reqd-slice)))))